/*
 * Handle client proximity requests
   indent indent -bli0 -bfda -kr -psl fms_client_proximity.c
 */
#include <unistd.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include "libfma.h"
#include "lf_fms_comm.h"
#include "lf_channel.h"
#include "lf_alert.h"
#include "lf_fabric.h"
#include "lf_proximity.h"

#include "fms.h"
#include "fms_error.h"
#include "fms_fabric.h"
#include "fms_client.h"

#define FMS_CLIENT_QUERY_MAX_LINE 256

/*
 *printf to a stream, returns 0 on error
*/

static int
fms_client_query_printf(int fd,
			char *fmt,
			...)
{
    int size;
    char buffer[FMS_CLIENT_QUERY_MAX_LINE];
    va_list args;
    va_start(args, fmt);
    size = vsnprintf(buffer, FMS_CLIENT_QUERY_MAX_LINE, fmt, args);
    va_end(args);
    return lf_write(fd, buffer, size) == size;
}

/*
 * collect proximity information from current fabric and write it all
 * as a giant ascii stream to the client's socket.
 * the format (for easy parsing by scripts i guess) is
 *   
     num_levels <number>
     level <number>
     num_groups <number>
     num_nics <number>
     <nic_name>
     <nic_name>
     ...
     num_nics <number>
     <nic_name>
     <nic_name>
     ...
     ...
     level <number>
     etc.
 

    prints num_levels 0 if the mapping is not done.
*/
void
fms_client_query_proximity(struct fms_client_desc *cdp)
{
    lf_fabric_t *fp;
    lf_proximity_t *p;
    int i, j, k;
    int *ip;

    fp = F.fabvars->fabric;


    /*if fabric is not done, just report 0 levels */

    if (FMS_FABRIC(fp)->request_map_adp ||
	FMS_FABRIC(fp)->push_map_task ||
	FMS_FABRIC(fp)->request_map_task ||
	!(p = lf_proximity_create(fp))) {
	fms_client_query_printf(cdp->chp->fd, "num_levels 0\n");
	return;
    }

    /*print it to stream */
    fms_client_query_printf(cdp->chp->fd, "num_levels %d\n",
			    p->num_levels);

    for (i = 0; i < p->num_levels; i++) {
	int num_groups;

	fms_client_query_printf(cdp->chp->fd, "level %d\n", p->levels[i]);
	ip = p->groups[i];
	num_groups = *ip++;
	fms_client_query_printf(cdp->chp->fd, "num_groups %d\n",
				num_groups);

	for (j = 0; j < num_groups; j++) {
	    int num_nics = *ip++;
	    fms_client_query_printf(cdp->chp->fd, "num_nics %d\n",
				    num_nics);

	    for (k = 0; k < num_nics; k++) {
		int nic = *ip++;
		lf_nic_t *np = p->nics[nic];
		fms_client_query_printf(cdp->chp->fd, "%s:%d\n",
					np->host->hostname,
					np->host_nic_id);
	    }
	}
    }
}
